using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    const long INF = (long)1e18;

    static void Main()
    {
        var first = Console.ReadLine().Split();
        int N = int.Parse(first[0]);
        long W = long.Parse(first[1]);
        double eps = double.Parse(first[2]);

        long[] w = new long[N];
        long[] v = new long[N];

        long vmax = 0;
        for (int i = 0; i < N; i++)
        {
            var line = Console.ReadLine().Split();
            w[i] = long.Parse(line[0]);
            v[i] = long.Parse(line[1]);
            vmax = Math.Max(vmax, v[i]);
        }

        // Skaliranje
        double Kd = eps * vmax / N;
        long K = (long)Math.Floor(Kd);
        if (K < 1) K = 1;

        int[] vs = new int[N];
        int sumV = 0;
        for (int i = 0; i < N; i++)
        {
            vs[i] = (int)(v[i] / K);
            sumV += vs[i];
        }

        long[] dp = new long[sumV + 1];
        int[,] take = new int[N, sumV + 1];

        for (int i = 1; i <= sumV; i++)
            dp[i] = INF;

        for (int i = 0; i < N; i++)
        {
            for (int val = sumV; val >= vs[i]; val--)
            {
                if (dp[val - vs[i]] + w[i] < dp[val])
                {
                    dp[val] = dp[val - vs[i]] + w[i];
                    take[i, val] = 1;
                }
            }
        }

        int bestV = 0;
        for (int val = 0; val <= sumV; val++)
            if (dp[val] <= W)
                bestV = val;

        // Rekonstrukcija
        List<int> result = new List<int>();
        int curV = bestV;

        for (int i = N - 1; i >= 0; i--)
        {
            if (curV >= vs[i] && take[i, curV] == 1)
            {
                result.Add(i + 1); // indeks 1-based
                curV -= vs[i];
            }
        }

        result.Reverse();

        Console.WriteLine(result.Count);
        Console.WriteLine(string.Join(" ", result));
    }
}